/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mail;

import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.arch.Path$;
import com.elixirtech.mail.ElxMail$;
import com.elixirtech.mail.MailAPI;
import com.elixirtech.mail.MailSender;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class SMTPServerImpl
implements MailSender {
    private final String UTF_8;

    public SMTPServerImpl() {
        this.UTF_8 = "utf-8";
    }

    public String UTF_8() {
        return this.UTF_8;
    }

    public abstract String hostName();

    public abstract void stop();

    @Override
    public LogMessage send(MailAPI.Mail2 mail) {
        MimeMessage msg = this.getEmptyMessage();
        MimeMultipart multipart = new MimeMultipart();
        this.constructMail(mail, msg, (Multipart)multipart);
        msg.setContent((Multipart)multipart);
        this.send(msg);
        ((LoggingMixin)this).log().info(() -> this.send$$anonfun$1(msg), Line$.MODULE$.apply(28), FullName$.MODULE$.apply("com.elixirtech.mail.SMTPServerImpl.send"));
        return LogMessage.None$.MODULE$;
    }

    private void constructMail(MailAPI.Mail2 mail, MimeMessage msg, Multipart multipart) {
        this.setToField(msg, mail.to());
        this.setCcField(msg, mail.cc());
        this.setBccField(msg, mail.bcc());
        this.setReplyTo(msg, mail.replyTo());
        this.setSubject(msg, mail.subject());
        this.setMessageBody(multipart, mail.message());
        if (mail.attachments().nonEmpty()) {
            this.addAttachment(multipart, mail.attachments());
            return;
        }
    }

    public abstract MimeMessage getEmptyMessage();

    public abstract void send(MimeMessage var1);

    public void setToField(MimeMessage msg, List<String> toList) {
        this.buildList((Message)msg, toList, Message.RecipientType.TO);
    }

    public void setCcField(MimeMessage msg, List<String> ccList) {
        this.buildList((Message)msg, ccList, Message.RecipientType.CC);
    }

    public void setBccField(MimeMessage msg, List<String> bccList) {
        this.buildList((Message)msg, bccList, Message.RecipientType.BCC);
    }

    public void setReplyTo(MimeMessage msg, List<String> replyTo) {
        msg.setReplyTo((Address[])ElxMail$.MODULE$.buildAddresses(replyTo).toArray(ClassTag$.MODULE$.apply(Address.class)));
    }

    public void setSubject(MimeMessage msg, String subject) {
        msg.setSubject((String)Option$.MODULE$.apply((Object)subject).getOrElse(SMTPServerImpl::setSubject$$anonfun$1), this.UTF_8());
    }

    public void setMessageBody(Multipart multipart, String content) {
        MimeBodyPart message = new MimeBodyPart();
        String body = (String)Option$.MODULE$.apply((Object)content).getOrElse(SMTPServerImpl::$anonfun$1);
        if (body.startsWith("<")) {
            message.setContent((Object)body, "text/html; charset=utf-8");
        } else {
            message.setText(body, this.UTF_8());
        }
        multipart.addBodyPart((BodyPart)message);
    }

    private void addAttachment(Multipart multipart, List<MailAPI.Attachment> attachments) {
        attachments.foreach((Function1)(JProcedure1 & Serializable)a -> {
            int idx = a.name().indexOf("|");
            String currFile = Path$.MODULE$.apply(idx >= 0 ? a.name().substring(0, idx) : a.name()).name();
            String attachmentName = MimeUtility.encodeText((String)currFile, (String)this.UTF_8(), null);
            MimeBodyPart attachment = new MimeBodyPart();
            Object object = Predef$.MODULE$.byteArrayOps(a.bytes());
            ByteArrayDataSource source = new ByteArrayDataSource((byte[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(Byte.TYPE)), a.mimeType());
            attachment.setDataHandler(new DataHandler((DataSource)source));
            attachment.setFileName(attachmentName);
            attachment.setContentID("<" + attachmentName + ">");
            multipart.addBodyPart((BodyPart)attachment);
        });
    }

    private void buildList(Message msg, List<String> recipients, Message.RecipientType rType) {
        List<Address> to = ElxMail$.MODULE$.buildAddresses(recipients);
        if (to.nonEmpty()) {
            msg.setRecipients(rType, (Address[])to.toArray(ClassTag$.MODULE$.apply(Address.class)));
            return;
        }
    }

    private final Object send$$anonfun$1(MimeMessage msg$1) {
        return BoxesRunTime.boxToInteger((int)msg$1.getSize()).toString() + " bytes sent through " + this.hostName();
    }

    private static final String setSubject$$anonfun$1() {
        return "";
    }

    private static final String $anonfun$1() {
        return "";
    }
}

