/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mail;

import com.elixirtech.arch.Crypt$;
import com.typesafe.config.Config;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;

public class SMTPServerSettings {
    private final String host;
    private final int port;
    private final int connectionTimeout;
    private final String from;
    private final String user;
    private final String password;
    private final boolean debug;
    private final boolean TLSEnabled;
    private final boolean SSLEnabled;
    private final String authMechanism;
    private final boolean hasAuth;
    private final Option optAuthMechanism;

    public SMTPServerSettings(Config config) {
        this.host = config.getString("host").trim();
        this.port = config.getInt("port");
        this.connectionTimeout = config.getInt("connectionTimeout");
        this.from = config.getString("from");
        this.user = Crypt$.MODULE$.encPrefixDecrypt(config.getString("user")).trim();
        this.password = Crypt$.MODULE$.encPrefixDecrypt(config.getString("password")).trim();
        this.debug = config.getBoolean("debug");
        this.TLSEnabled = config.getBoolean("tls");
        this.SSLEnabled = config.getBoolean("ssl");
        this.authMechanism = config.getString("authMechanism");
        this.hasAuth = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.user())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.password()));
        this.optAuthMechanism = this.authMechanism().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)this.authMechanism());
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public String from() {
        return this.from;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean TLSEnabled() {
        return this.TLSEnabled;
    }

    public boolean SSLEnabled() {
        return this.SSLEnabled;
    }

    public String authMechanism() {
        return this.authMechanism;
    }

    public boolean hasAuth() {
        return this.hasAuth;
    }

    public Option<String> optAuthMechanism() {
        return this.optAuthMechanism;
    }
}

