/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.api.WebAPI;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.arch.package$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.DBUtils$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.Serializable;
import monix.execution.Scheduler$;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class MongoDBAccessAppender
implements WebAPI.WebAccessAppender,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBAccessAppender.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBAccessAppender.class.getDeclaredField("eventsCollection$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final ExecutionContext exeCxt;
    private volatile Object eventsCollection$lzy1;
    private final BsonString pid;
    private final Option<BsonString> pidMachine;
    private final BsonInt32 runValue;

    public MongoDBAccessAppender(MongoDB mongoDB, RunInfo runInfo) {
        this.mongoDB = mongoDB;
        this.exeCxt = mongoDB.sysConfig().exeCxt();
        this.pid = new BsonString(JavaPID$.MODULE$.value());
        this.pidMachine = BsonUtils$.MODULE$.pidMachine(this.pid);
        this.runValue = new BsonInt32(runInfo.runId());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ExecutionContext exeCxt() {
        return this.exeCxt;
    }

    private RichMongoCollection eventsCollection() {
        Object object = this.eventsCollection$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.eventsCollection$lzyINIT1();
    }

    private Object eventsCollection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.eventsCollection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection((MongoCollection<Document>)this.mongoDB.logs().getCollection("LogAccess", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.eventsCollection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void append(WebAPI.WebAccess access) {
        this.eventsCollection().insertOneT(this.toMongoDocument(access)).void().runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public Document toMongoDocument(WebAPI.WebAccess access) {
        BsonDocument doc = new BsonDocument();
        DBUtils$.MODULE$.appendTimestamp(doc, access.received());
        doc.append("run", (BsonValue)this.runValue);
        doc.append("pid", (BsonValue)this.pid);
        this.pidMachine.foreach((Function1 & Serializable)s -> doc.append("pidMachine", (BsonValue)s));
        access.getServerName().foreach((Function1 & Serializable)sn -> doc.append("server", (BsonValue)new BsonString(sn)));
        this.addRemote(doc, access);
        this.addRequest(doc, access);
        this.addResponse(doc, access);
        return Document$.MODULE$.apply(doc);
    }

    private void addRemote(BsonDocument doc, WebAPI.WebAccess access) {
        BsonDocument remote = new BsonDocument();
        access.getRemoteAddr().foreach((Function1 & Serializable)ra -> remote.append("addr", (BsonValue)new BsonString(ra)));
        doc.put("remote", (BsonValue)remote);
    }

    private void addRequest(BsonDocument doc, WebAPI.WebAccess access) {
        BsonDocument request = new BsonDocument();
        access.getRequestURI().foreach((Function1 & Serializable)uri -> request.append("uri", (BsonValue)new BsonString(uri)));
        request.append("protocol", (BsonValue)new BsonString(access.getProtocol()));
        request.append("method", (BsonValue)new BsonString(access.getMethod()));
        request.append("path", (BsonValue)new BsonString(access.getPath()));
        request.append("contentLength", (BsonValue)new BsonInt64(access.getRequestContentLength()));
        access.getSessionID().foreach((Function1 & Serializable)s -> request.append("sessionId", (BsonValue)new BsonString(s)));
        access.getRequestHeader("User-Agent").foreach((Function1 & Serializable)ua -> request.append("userAgent", (BsonValue)new BsonString(ua)));
        access.getRequestHeader("Referer").foreach((Function1 & Serializable)r -> request.append("referer", (BsonValue)new BsonString(r)));
        access.getRequestHeader("Content-Type").foreach((Function1 & Serializable)ct -> request.append("contentType", (BsonValue)new BsonString(ct)));
        access.getRequestHeader("Content-Length").flatMap((Function1 & Serializable)len -> package$.MODULE$.richWrapper(len).toOptLong()).foreach((Function1 & Serializable)len -> request.append("contentLength", (BsonValue)new BsonInt64(BoxesRunTime.unboxToLong((Object)len))));
        doc.put("request", (BsonValue)request);
    }

    private void addResponse(BsonDocument doc, WebAPI.WebAccess access) {
        BsonDocument response = new BsonDocument();
        response.append("contentLength", (BsonValue)new BsonInt64(access.getResponseContentLength()));
        response.append("statusCode", (BsonValue)new BsonInt32(access.getStatusCode()));
        response.append("elapsedTime", (BsonValue)new BsonInt64(access.elapsedTime()));
        access.getResponseHeader("Content-Type").foreach((Function1 & Serializable)ct -> response.append("contentType", (BsonValue)new BsonString(ct)));
        doc.put("response", (BsonValue)response);
    }
}

