/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzWbb;
import com.aspose.words.internal.zzWcl;
import com.aspose.words.internal.zzWgE;
import com.aspose.words.internal.zzXdc;
import com.aspose.words.internal.zzY02;
import com.aspose.words.internal.zzY5i;
import com.aspose.words.internal.zzZ0p;
import com.aspose.words.internal.zzZQa;
import com.aspose.words.internal.zzZTn;
import com.aspose.words.internal.zzZbl;
import com.aspose.words.internal.zzx3;
import com.aspose.words.internal.zzyk;
import com.aspose.words.zzLv;
import com.aspose.words.zzQ6;
import com.aspose.words.zzWs1;
import com.aspose.words.zzXW9;
import com.aspose.words.zzXeF;
import com.aspose.words.zzY2F;
import com.aspose.words.zzYsz;
import com.aspose.words.zzZO0;
import com.aspose.words.zzZQf;
import com.aspose.words.zzZxH;
import com.aspose.words.zzwf;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXsO(zzWgE zzWgE2, zzWgE zzWgE3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzx3.zzVQb((Object)zzWgE2, "srcStream");
        zzx3.zzVQb((Object)zzWgE3, "dstStream");
        zzx3.zzVQb((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzVQb(zzWgE2, zzWgE3, certificateHolder, signOptions);
        zzWgE3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXsO(zzWgE.zzVQb(srcStream), (zzWgE)zzWgE.zzWRw(dstStream), certHolder, signOptions);
    }

    private static void zzVQb(zzWgE zzWgE2, zzWgE zzWgE3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWRw(digitalSignature);
        }
        if (zzYsz.zzZnD(zzWgE2)) {
            DigitalSignatureUtil.zzXsO(zzWgE2, zzWgE3, digitalSignature, true);
            return;
        }
        zzYsz zzYsz2 = new zzYsz();
        zzWgE zzWgE4 = zzWgE2;
        zzYsz zzYsz3 = zzYsz2;
        FileFormatInfo fileFormatInfo = zzYsz2.zzVQb(zzWgE4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZQa zzZQa2 = new zzZQa(zzWgE2);
                int n = fileFormatInfo.zzWzN() == 1 ? 1 : 2;
                zzQ6.zzXsO(zzZQa2, digitalSignature, n);
                zzWgE3.zzZEd(0L);
                zzZQa2.zzZyv(zzWgE3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXsO(fileFormatInfo.zzX94(), zzWgE3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXsO(zzWgE2, zzWgE3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzXsO(zzWgE2, zzWgE3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzx3.zzWRw(srcFileName, "srcFileName");
        zzx3.zzWRw(dstFileName, "dstFileName");
        try (zzZTn zzZTn2 = zzx3.zzVQb(srcFileName, 3, 1);){
            try (zzZTn zzZTn3 = zzx3.zzVQb(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXsO((zzWgE)zzZTn2, (zzWgE)zzZTn3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzWcl zzWcl2 = zzWgE.zzWRw(dstStream);
        zzWgE zzWgE2 = zzWgE.zzVQb(srcStream);
        DigitalSignatureUtil.zzXsO(zzWgE2, (zzWgE)zzWcl2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzZTn zzZTn2 = zzx3.zzVQb(srcFileName, 3, 1);){
            try (zzZTn zzZTn3 = zzx3.zzVQb(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXQ4(zzZTn2, zzZTn3);
            }
            return;
        }
    }

    private static void zzXQ4(zzWgE zzWgE2, zzWgE zzWgE3) throws Exception {
        zzYsz zzYsz2 = new zzYsz();
        zzWgE zzWgE4 = zzWgE2;
        Object object = zzYsz2;
        FileFormatInfo fileFormatInfo = zzYsz2.zzVQb(zzWgE4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZQa zzZQa2 = new zzZQa(zzWgE2);
                zzZQa2.zzLK().zzVr("_xmlsignatures");
                zzZQa2.zzLK().zzVr("_signatures");
                zzWgE3.zzXoC(0L);
                zzZQa2.zzZyv(zzWgE3);
                zzWgE zzWgE5 = zzWgE3;
                zzWgE5.zzZEd(zzWgE5.zzXjA());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZbl zzZbl2 = new zzZbl(zzWgE2);
                zzY02 zzY022 = zzZbl2.zzXsO(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzY022 != null) {
                    for (zzY5i zzY5i2 : zzY022.zz3v()) {
                        String string = zzY022.zzXsO(zzY5i2);
                        zzZbl2.zzY1R().remove(string);
                    }
                    zzZbl2.zzY1R().remove(zzY022.getName());
                    zzY5i zzY5i3 = zzZbl2.zz3v().zzWtD("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZbl2.zz3v().remove(zzY5i3.getId());
                    zzZbl2.zzZZ4();
                }
                zzWgE3.zzXoC(0L);
                zzZbl2.zzZyv(zzWgE3);
                zzWgE zzWgE6 = zzWgE3;
                zzWgE6.zzZEd(zzWgE6.zzXjA());
                return;
            }
            case 60: 
            case 61: {
                zzZxH zzZxH2 = new zzZxH(zzWgE2);
                zzZQf zzZQf2 = zzZxH2.zzXmn("/META-INF/documentsignatures.xml");
                if (zzZQf2 != null) {
                    zzZxH2.zzXOX().remove(zzZQf2.getName());
                }
                zzWgE3.zzXoC(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzWgE4 = zzWgE3;
                object = zzZxH2;
                ((zzZxH)object).zzXsO(zzWgE4, string, null);
                zzWgE zzWgE7 = zzWgE3;
                zzWgE7.zzZEd(zzWgE7.zzXjA());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXQ4(zzWgE.zzVQb(srcStream), zzWgE.zzWRw(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzZTn zzZTn2 = zzx3.zzVQb(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYX2(zzZTn2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYX2(zzWgE zzWgE2) throws Exception {
        if (zzYsz.zzZnD(zzWgE2)) {
            return DigitalSignatureUtil.zzYek(zzWgE2);
        }
        zzYsz zzYsz2 = new zzYsz();
        zzWgE zzWgE3 = zzWgE2;
        zzYsz zzYsz3 = zzYsz2;
        FileFormatInfo fileFormatInfo = zzYsz2.zzVQb(zzWgE3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzWgE2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYX2(zzWgE.zzVQb(stream));
    }

    static zzyk zzXsO(zzZQa zzZQa2, String string) throws Exception {
        zzWs1 zzWs12 = new zzWs1(zzZQa2);
        if (zzWs12.zzYiB()) {
            zzyk zzyk2 = zzWs12.zzVOD(string);
            return zzyk2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzVYv(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXdc.zzVQb("Unexpected digest algorithm: {0}.", n));
    }

    static String zzC2(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzVYv(n);
    }

    private static void zzXsO(zzWgE zzWgE2, zzWgE zzWgE3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZbl zzZbl2 = new zzZbl(zzWgE2);
        zzwf zzwf2 = bl ? new zzY2F(zzZbl2) : new zzLv(zzZbl2);
        zzwf2.zzVQb(digitalSignature);
        zzWgE3.zzZEd(0L);
        zzZbl2.zzZyv(zzWgE3);
    }

    private static void zzXsO(zzWgE zzWgE2, zzWgE zzWgE3, DigitalSignature digitalSignature) throws Exception {
        zzZxH zzZxH2 = new zzZxH(zzWgE2);
        zzXW9 zzXW92 = new zzXW9(zzZxH2);
        zzXW92.zzVQb(digitalSignature);
        zzWgE3.zzZEd(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzWgE zzWgE4 = zzWgE3;
        zzZxH zzZxH3 = zzZxH2;
        zzZxH3.zzXsO(zzWgE4, string, null);
    }

    private static void zzXsO(zzZQa zzZQa2, zzWgE zzWgE2, DigitalSignature digitalSignature, String string) throws Exception {
        zzyk zzyk2 = DigitalSignatureUtil.zzXsO(zzZQa2, string);
        zzyk zzyk3 = new zzyk();
        DigitalSignatureUtil.zzXsO((zzWgE)zzyk2, (zzWgE)zzyk3, digitalSignature, false);
        zzZQa zzZQa3 = zzWs1.zzXQ4(zzyk3, string);
        zzZQa3.zzZyv(zzWgE2);
    }

    private static DigitalSignatureCollection zzYek(zzWgE zzWgE2) throws Exception {
        zzWgE2.zzXoC(0L);
        zzZbl zzZbl2 = new zzZbl(zzWgE2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzY02 zzY022 = zzZbl2.zzXsO(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzY022 != null) {
            for (zzY5i zzY5i2 : zzY022.zz3v()) {
                String string = zzY022.zzXsO(zzY5i2);
                zzY02 zzY023 = zzZbl2.zzlK(string);
                zzY02 zzY024 = zzZbl2.zzXsO(zzY023, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZ0p zzZ0p2 = zzWbb.zzZyv(zzY024.zzYjA().zzW0X());
                zzXeF.zzXsO(zzY023.zzXbP(), zzZ0p2, new zzZO0(zzZbl2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

