/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWW2;
import com.aspose.words.internal.zzXN8;
import com.aspose.words.internal.zzXdc;
import com.aspose.words.internal.zzZ7p;
import com.aspose.words.internal.zziG;
import com.aspose.words.internal.zzx3;
import com.aspose.words.zzWTs;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzXei;
    private zzWTs zzlp;

    Watermark(Document doc, zzWTs watermarkProvider) {
        this.zzXei = doc;
        this.zzlp = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzYm2(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXsO(text, textWatermarkOptions, this.zzXei);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzx3.zzVQb((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzXei, 75);
        shape.getImageData().setImage(image);
        this.zzXsO(shape, options, this.zzXei);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzx3.zzVQb((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzXei, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXsO(shape, options, this.zzXei);
    }

    public final int getType() {
        Shape shape = this.zzlp.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWPl();
        if (shape.zzZtp()) {
            return 0;
        }
        if (shape.zzYQ2()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzlp.add(shape);
    }

    public final void remove() {
        this.zzlp.remove();
    }

    private static void zzYm2(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzXN8.zzZsp(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzx3.zzXsO(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXsO(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzVQb(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXQ4(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzVQb(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZQ5() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzYRn()) / d2) > (double)(f = pageSetup.zzQB())) {
            d = (double)f / d3;
        }
        shape.zzZVw(zzWW2.zzWRw(d2 * d, 2, 1));
        shape.zzWbb(zzWW2.zzWRw(d3 * d, 2, 1));
    }

    private Shape zzXsO(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXsO(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXQ4(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXsO(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYTM() ? 1.0f : textWatermarkOptions.getFontSize();
        zzZ7p zzZ7p2 = document.zzXD4().zzWRw(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzZ7p2.zzVPh(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYTM()) {
            l = Watermark.zzXsO(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZVw(zzWW2.zzWRw(Float.intBitsToFloat(n), 2, 1));
        shape.zzWbb(zzWW2.zzWRw(zziG.zzXZD(l), 2, 1));
    }

    private static long zzXsO(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzYRn();
        float f2 = pageSetup.zzQB();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zziG.zzXZD(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zziG.zzVQU(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zziG.zzXZD(l) >= Float.intBitsToFloat(n)) {
            return zziG.zzVQU(f2 / f3, f2);
        }
        float f6 = f;
        return zziG.zzVQU(f6, f6 * f3);
    }

    private static void zzXQ4(Shape shape, String string) {
        shape.setName(zzXdc.zzVQb("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

